// Code generated by smithy-go-codegen DO NOT EDIT.

package qbusiness

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qbusiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets information about an existing Amazon Q Business index.
func (c *Client) GetIndex(ctx context.Context, params *GetIndexInput, optFns ...func(*Options)) (*GetIndexOutput, error) {
	if params == nil {
		params = &GetIndexInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetIndex", params, optFns, c.addOperationGetIndexMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetIndexOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetIndexInput struct {

	// The identifier of the Amazon Q Business application connected to the index.
	//
	// This member is required.
	ApplicationId *string

	// The identifier of the Amazon Q Business index you want information on.
	//
	// This member is required.
	IndexId *string

	noSmithyDocumentSerde
}

type GetIndexOutput struct {

	// The identifier of the Amazon Q Business application associated with the index.
	ApplicationId *string

	// The storage capacity units chosen for your Amazon Q Business index.
	CapacityConfiguration *types.IndexCapacityConfiguration

	// The Unix timestamp when the Amazon Q Business index was created.
	CreatedAt *time.Time

	// The description for the Amazon Q Business index.
	Description *string

	// The name of the Amazon Q Business index.
	DisplayName *string

	// Configuration information for document attributes or metadata. Document
	// metadata are fields associated with your documents. For example, the company
	// department name associated with each document. For more information, see [Understanding document attributes].
	//
	// [Understanding document attributes]: https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes-types.html#doc-attributes
	DocumentAttributeConfigurations []types.DocumentAttributeConfiguration

	// When the Status field value is FAILED , the ErrorMessage field contains a
	// message that explains why.
	Error *types.ErrorDetail

	//  The Amazon Resource Name (ARN) of the Amazon Q Business index.
	IndexArn *string

	// The identifier of the Amazon Q Business index.
	IndexId *string

	// Provides information about the number of documents indexed.
	IndexStatistics *types.IndexStatistics

	// The current status of the index. When the value is ACTIVE , the index is ready
	// for use. If the Status field value is FAILED , the ErrorMessage field contains
	// a message that explains why.
	Status types.IndexStatus

	// The type of index attached to your Amazon Q Business application.
	Type types.IndexType

	// The Unix timestamp when the Amazon Q Business index was last updated.
	UpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetIndexMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetIndex{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetIndex{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetIndex"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetIndexValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetIndex(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetIndex(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetIndex",
	}
}
